<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_FreeShippingBar
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\FreeShippingBar\Helper;

use \Magento\Framework\App\Helper\AbstractHelper;
use \Bss\FreeShippingBar\Helper\Data as FreeShippingBarData;

class FreeShippingBar extends AbstractHelper
{

    /**
     * @var Data
     */
    protected $helperData;

    /**
     * @var \Magento\Framework\App\Http\Context
     */
    protected $httpContext;

    /**
     * FreeShippingBar constructor.
     *
     * @param \Magento\Framework\App\Helper\Context $context
     * @param Data $helperData
     * @param \Magento\Framework\App\Http\Context $httpContext
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        FreeShippingBarData $helperData,
        \Magento\Framework\App\Http\Context $httpContext
    ) {
        $this->helperData = $helperData;
        $this->httpContext = $httpContext;
        parent::__construct($context);
    }

    /**
     * Filter Thresholds by customer group.
     *
     * @return bool|mixed
     */
    private function getThresholdByCustomerGroup()
    {

        $thresholds = $this->helperData->getThreshold();

        if (is_array($thresholds)) {
            foreach ($thresholds as $theshHold) {
                if ($theshHold['customer_group'] == $this->getCustomerGroup()) {
                    return $theshHold;
                }
            }
        }
        return false;
    }

    /**
     * Check Customer logged in
     *
     * @return mixed|null
     */
    protected function isCustomerLoggedIn()
    {
        return $this->httpContext->getValue(\Magento\Customer\Model\Context::CONTEXT_AUTH);
    }

    /**
     * Get Customer Group
     *
     * @return int|mixed|null
     */
    public function getCustomerGroup()
    {
        if ($this->isCustomerLoggedIn()) {
            return $this->httpContext->getValue(\Magento\Customer\Model\Context::CONTEXT_GROUP);
        } else {
            return \Magento\Customer\Model\Group::NOT_LOGGED_IN_ID;
        }
    }

    /**
     * Return Free Shipping Message for cart section data.
     *
     * @return string
     */
    public function getMessage($cartData)
    {
        $message = '';

        if ($this->helperData->isEnable() && $this->getThresholdByCustomerGroup()) {
            try {
                $rate = (float)$this->helperData->getStore()->getCurrentCurrencyRate();
                $symbol = $this->helperData->getPriceCurrency()->getCurrency()->getCurrencySymbol();
                $threshold = $this->getThresholdByCustomerGroup();
                $thresholdValue = (float)$rate * $threshold['threshold'];
                $cartSubtotal = (float)$cartData['subtotalAmount'];
                if ($thresholdValue > $cartSubtotal) {
                    $leftValue = $thresholdValue - $cartSubtotal;
                    $thresholdValue = $this->helperData->getCurrency()->formatTxt(
                        $thresholdValue,
                        ['display' => $symbol]
                    );
                    $leftValue = $this->helperData->getCurrency()->formatTxt($leftValue, ['display' => $symbol]);
                    $cartSubtotal = $this->helperData->getCurrency()->formatTxt($cartSubtotal, ['display' => $symbol]);
                    $message = str_replace(
                        "{thresholdValue}",
                        "<em style='color:" . $this->helperData->getValueColor() . "'>" . $thresholdValue . "</em>",
                        $threshold['message']
                    );
                    $message = str_replace(
                        "{leftValue}",
                        "<em style='color:" . $this->helperData->getValueColor() . "'>" . $leftValue . "</em>",
                        $message
                    );
                    $message = str_replace(
                        "{cartSubtotal}",
                        "<em style='color:" . $this->helperData->getValueColor() . "'>" . $cartSubtotal . "</em>",
                        $message
                    );
                } else {
                    $message = $this->helperData->getSuccessMessage();
                }
            } catch (\Exception $exception) {
                $this->_logger->error($exception->getMessage());
            }
        }
        return $message;
    }
}
