Google Cloud Storage Extension for Magento 2
============================================

This extension allows retailers to upload and sync their catalogue and WYSIWYG
images to/with Google Cloud Storage. Based heavily on [Arkade S3
extension](https://github.com/shobhitsinghal624/magento2-s3).

## Installation
```sh
$ composer req bangerkuwranger/magento2-google-cloud-storage:dev-master
```
## Configuration
- Go to Google Cloud Console (Make sure the right project is selected)
- Click on CREATE SERVICE ACCOUNT, insert a Service Account Name and click Continue
- Add the following roles:
    - Storage Admin
    - Storage Object Admin
    - Storage Transfer Admin

    and click Continue.
    
- Click on CREATE KEY button, select JSON format and Save in your computer.
Click DONE button.
Open downloaded json file, copy his content and put in the field under Google Cloud
configuration in backoffice:

- (Store -> Configuration -> Google Cloud Storage -> Google Cloud)

- In this tab add all folder of media that you don't want to sync to GCS into "Excluded Folder" field.
- To sync your media in GCS launch:
```sh
  $ bin/magento gcs:storge:sync --enable
```
    (--enable needed to set automatically file system usage to GCS)
- Under "general/web" change all url for user media files with:
```sh
  https://storage.googleapis.com/[bucket-name]
```
    ! please change "[bucket-name]" with your bucket !
    
#Best practices
Replace any usage of "relative path" to media folder, in all code with the following method:
```sh
  <?= $this->helper('Magento\Cms\Helper\Wysiwyg\Images')->getBaseUrl() ?>
``` 
(for example search /pub/media and /media and replace)
## Description

## Requirements
- PHP >= 7.0.0
- bangerkuwranger/google-cloud-storage-php-wrapper: dev-master

## Compatibility
- Magento >= 2.2
- Not tested on 2.1 and 2.0

## Support
If you encounter any problems or bugs, please contact us [here](https://www.drop.it) or create an issue.

## Developer
Cristiano Pieroni (c.pieroni@drop.it)

## TODO
* Dare la possibilità di fare upload di un singolo file o di una intera cartella dentro media


Benefits
--------

### Sync all your media images

The following images are automatically synced with GCS:

-   Product images

-   Generated thumbnails

-   WYSIWYG images

-   Category images

### Magento can now scale horizontally

Complex file syncing between multiple servers is now a thing of the past. Your
servers will be able to share the one GCS bucket as the source for media files.


Credits
-------

Original logic was written for Amazon S3 by [Thai
Phan](https://github.com/thaiphan)

Initial port and some logic changes for GCS done by [Chad A.
Carino](https://github.com/bangerkuwranger)

Complete rewrite of logic, namespacing, and all GCS functions within Magento 2
context done by [Ramki Rajamanickam](https://github.com/ram10raj)
