<?php
namespace Google\Cloud\Helper;

use Google\Cloud\Model\MediaStorage\File\Storage;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    private $useGCS = null;
    private $excludedFolder = [];

    /**
     * @return bool
     */
    public function checkGCSUsage()
    {
        if (is_null($this->useGCS)) {
            $currentStorage = (int)$this->scopeConfig->getValue(Storage::XML_PATH_STORAGE_MEDIA);
            $this->useGCS = $currentStorage == Storage::STORAGE_MEDIA_GCS;
        }
        return $this->useGCS;
    }

    public function getAccessKey()
    {
        return $this->scopeConfig->getValue('google_cloud/general/access_key');
    }

    public function getProject()
    {
        return $this->scopeConfig->getValue('google_cloud/general/project');
    }

    public function getRegion()
    {
        return $this->scopeConfig->getValue('google_cloud/general/region');
    }

    public function getBucket()
    {
        return $this->scopeConfig->getValue('google_cloud/general/bucket');
    }

    public function getExcludedFolder()
    {
        if(empty($this->excludedFolder)) {
            foreach(explode(PHP_EOL, $this->scopeConfig->getValue('google_cloud/general/excluded_folder')) as $excludedFolder) {
                if(!empty(trim($excludedFolder))) {
                    $this->excludedFolder[] = trim($excludedFolder);
                }
            }
        }
        return $this->excludedFolder;
    }

    /**
     * @param string $folderToCheck
     * @return bool
     */
    public function getIsAnExcludedFolder(string $folderToCheck) {
        foreach($this->getExcludedFolder() as $excludedFolder) {
            if(strpos($folderToCheck, $excludedFolder) === 0) {
                return true;
            }
        }
        return false;
    }

    public function validate()
    {
        $errors = [];
        if (is_null($this->getAccessKey())) {
            $errors[] = 'You have not provided an GCS access key ID. You can do so using our config script.';
        }
        if (is_null($this->getProject())) {
            $errors[] = 'You have not provided an GCS Project Number. You can do so using our config script.';
        }
        if (is_null($this->getBucket())) {
            $errors[] = 'You have not provided an GCS bucket. You can do so using our config script.';
        }
        if (is_null($this->getRegion())) {
            $errors[] = 'You have not provided an GCS region. You can do so using our config script.';
        }
        return $errors;
    }

//    public function is_dir_empty($dir) {
//        if (!is_readable($dir)) return false;
//        return (count(scandir($dir)) == 2);
//    }
//
//    public function getIsCatalogProductOriginalImage($filePath) {
//        if(strpos($filePath, 'catalog/product') !== false && strpos($filePath, 'catalog/product/cache') === false) {
//            return true;
//        }
//        return false;
//    }
//
//    public function getIsCatalogProductCacheImage($filePath) {
//        if(strpos($filePath, 'catalog/product/cache') == false) {
//            return true;
//        }
//        return false;
//    }

}
