<?php

namespace Google\Cloud\Framework\Image;

use Magento\MediaStorage\Helper\File\Storage\Database;
use Google\Cloud\Helper\Data;

class Plugin
{
    /**
     * @var Data
     */
    private $helper;
    /**
     * @var Database
     */
    private $database;

    /**
     * @param Data $helper
     * @param Database $database
     */
    public function __construct(
        Data $helper,
        Database $database
    )
    {
        $this->helper = $helper;
        $this->database = $database;
    }

    /**
     * @param $subject
     * @param $result
     * @param null $destination
     * @param null $newFileName
     * @return mixed
     */
    public function afterSave($subject, $result, $destination = null, $newFileName = null)
    {
        if ($this->helper->checkGCSUsage()) {
            $relativeImgFile = $this->database->getMediaRelativePath($destination);
            $this->database->getStorageDatabaseModel()->saveFile($relativeImgFile);
        }
        return $result;
    }

}
