<?php
/**
 * Created by PhpStorm.
 * User: marcoprontera
 * Date: 01/07/20
 * Time: 9.45
 */
namespace Google\Cloud\Console\Command;

use Magento\Config\Model\Config\Factory;
use Psr\Log\InvalidArgumentException;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class RemoveEventBasedOnAllFilesInBucket extends \Symfony\Component\Console\Command\Command
{
    private $client;

    /**
     * @var \Magento\Config\Model\Config\Factory
     */
    private $configFactory;
    /**
     * @var \Magento\Framework\App\State
     */
    private $state;
    /**
     * @var \Google\Cloud\Helper\Data
     */
    private $helper;
    /**
     * @var \Magento\MediaStorage\Helper\File\Storage
     */
    private $coreFileStorage;
    /**
     * @var \Magento\MediaStorage\Helper\File\Storage\Database
     */
    private $storageHelper;
    /**
     * @var \Google\Cloud\Logger\Logger
     */
    private $logger;

    /**
     * StorageSyncCommand constructor.
     * @param \Magento\Framework\App\State $state
     * @param \Magento\Config\Model\Config\Factory $configFactory
     * @param \Magento\MediaStorage\Helper\File\Storage\Database $storageHelper
     * @param \Magento\MediaStorage\Helper\File\Storage $coreFileStorage
     * @param \Google\Cloud\Helper\Data $helper
     * @param \Google\Cloud\Logger\Logger $logger
     */
    public function __construct(
        \Magento\Framework\App\State $state,
        Factory $configFactory,
        \Magento\MediaStorage\Helper\File\Storage\Database $storageHelper,
        \Magento\MediaStorage\Helper\File\Storage $coreFileStorage,
        \Google\Cloud\Helper\Data $helper,
        \Google\Cloud\Logger\Logger $logger
    ) {
        $this->state = $state;
        $this->configFactory = $configFactory;
        $this->coreFileStorage = $coreFileStorage;
        $this->helper = $helper;
        $this->storageHelper = $storageHelper;
        $this->logger = $logger;
        parent::__construct();
    }

    protected function configure()
    {
        $this->setName('gcs:unset-event-hold:all-files')
            ->setDescription('Remove event-hold')
            ->addArgument('bucketname', InputOption::VALUE_REQUIRED, 'The bucketname used.');
        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if(!$input->getArgument('bucketname')){
            throw new InvalidArgumentException('You must add a bucketname when you call this command');
        }

        $json_key = $this->helper->getAccessKey();
        $key_array = json_decode($json_key,true);
        $project = $key_array['project_id'];
        $connection = new \Google\Cloud\ServiceBuilder([
            'projectId'	=> $project,
            'keyFile'	=> $key_array
        ]);
        $storage = $connection->storage();

        $bucket = $storage->bucket($input->getArgument('bucketname'));

        if ($bucket->info()['defaultEventBasedHold']) {
            $output->writeln('WARNING: Default event-based hold is enabled' . PHP_EOL);
        } else {
            $output->writeln('Default event-based hold is not enabled!' . PHP_EOL);
        }

        foreach($bucket->objects() as $object) {
            $object = $bucket->object($object->name());
            $output->writeln('Response:' . var_dump($object->update([
                    'eventBasedHold' => false,
                    'temporaryHold' => false,
                ])));
        }

        $output->writeln(sprintf('Finished set eventBasedHold and temporaryHold to false on GCS Bucket: '. $bucket->name()));

    }


}
