<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Magento 2 Base Package
*/
declare(strict_types=1);

namespace Amasty\Base\Plugin\Backend\Model\Menu;

use Magento\Backend\Model\Menu;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ProductMetadataInterface;
use Magento\Store\Model\ScopeInterface;

class Builder
{
    public const BASE_MENU = 'MenuAmasty_Base::menu';
    public const XPATH_SETTING_ENABLE = 'amasty_base/menu/enable';

    /**
     * @var ProductMetadataInterface
     */
    private $metadata;

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    public function __construct(
        ProductMetadataInterface $metadata,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->metadata = $metadata;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @param Menu\Builder $subject
     * @param Menu $menu
     * @return Menu
     */
    public function afterGetResult(Menu\Builder $subject, Menu $menu): Menu
    {
        $this->validateMenu($menu);

        return $menu;
    }

    /**
     * Validates Menu for further processing
     *
     * @param Menu $menu
     */
    private function validateMenu(Menu $menu): void
    {
        if (!$menu->get(self::BASE_MENU)) {
            return;
        }

        if (version_compare($this->metadata->getVersion(), '2.2.0', '<')
            || !$this->scopeConfig->isSetFlag(self::XPATH_SETTING_ENABLE, ScopeInterface::SCOPE_STORE)
        ) {
            $menu->remove(self::BASE_MENU);
        }
    }
}
