<?php

namespace Adfab\Gdpr\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\App\Helper\AbstractHelper;

/**
 * Cipher helper
 */
class Data extends AbstractHelper
{

    const XML_PATH_CUSTOMER_PROFILING = 'customer/privacy/is_profiling_accepted';
    const XML_PATH_CUSTOMER_ACCOUNT_DELETION = 'customer/privacy/account_deletion';
    const XML_PATH_CUSTOMER_EXPORT = 'customer/privacy/export';
    const XML_PATH_PRIVACY_URL = 'customer/privacy/privacy_url';

    /**
     *
     * @var bool
     */
    protected $profilingActive;

    /**
     *
     * @var bool
     */
    protected $accountDeletionActive;

    /**
     *
     * @var bool
     */
    protected $exportActive;


    /**
     *
     * @return boolean
     */
    public function getProfilingActive()
    {
        if ( ! isset( $this->profilingActive) ) {
            $this->profilingActive = $this->scopeConfig->getValue(self::XML_PATH_CUSTOMER_PROFILING) ? true : false;
        }
        return $this->profilingActive;
    }

    /**
     *
     * @return boolean
     */
    public function getAccountDeletionActive()
    {
        if ( ! isset( $this->accountDeletionActive) ) {
            $this->accountDeletionActive = $this->scopeConfig->getValue(self::XML_PATH_CUSTOMER_ACCOUNT_DELETION) ? true : false;
        }
        return $this->accountDeletionActive;
    }

    /**
     *
     * @return boolean
     */
    public function getExportActive()
    {
        if ( ! isset( $this->exportActive) ) {
            $this->exportActive = $this->scopeConfig->getValue(self::XML_PATH_CUSTOMER_EXPORT) ? true : false;
        }
        return $this->exportActive;
    }

    public function getPrivacyPolicyUrl($scope) {
        return $this->scopeConfig->getValue(self::XML_PATH_PRIVACY_URL, $scope);
    }
}
