<?php
/**
 * Copyright (C) 2017 Adfab
 *
 * This file is part of Adfab/Gdpr.
 */

namespace Adfab\Gdpr\Console\Command;

use Symfony\Component\Console\Input\InputArgument;

/**
 * Class Decrypt
 * @package Adfab\Gdpr\Console\Command
 */
class Decrypt extends \Symfony\Component\Console\Command\Command
{

    /**
     * @var \Magento\Framework\App\State
     */
    protected $state;

    /**
     * @var \Adfab\Gdpr\Helper\Cipher
     */
    protected $cipher;

    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\CollectionFactory
     */
    protected $orderCollectionFactory;
    
    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\Address\CollectionFactory
     */
    protected $orderAddressCollectionFactory;

    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\Grid\CollectionFactory
     */
    protected $orderGridCollectionFactory;

    /**
     * @var \Magento\Customer\Model\ResourceModel\Customer\CollectionFactory
     */
    protected $customerCollectionFactory;

    /**
     * @var \Magento\Customer\Model\ResourceModel\Address\CollectionFactory
     */
    protected $customerAddressCollectionFactory;

    /**
     * @var \Magento\Quote\Model\ResourceModel\Quote\CollectionFactory
     */
    protected $quoteCollectionFactory;

    /**
     * @var \Magento\Newsletter\Model\ResourceModel\Subscriber\CollectionFactory
     */
    protected $subscriberCollectionFactory;

    /**
     * @var \Magento\Sales\Api\OrderRepositoryInterface
     */
    protected $orderRepository;

    /**
     * @var \Magento\Sales\Api\OrderAddressRepositoryInterface
     */
    protected $orderAddressRepository;

    /**
     * @var \Magento\Customer\Api\CustomerRepositoryInterface
     */
    protected $customerRepository;

    /**
     * @var \Magento\Customer\Api\AddressRepositoryInterface
     */
    protected $customerAddressRepository;

    /**
     * @var \Magento\Quote\Api\CartRepositoryInterface
     */
    protected $quoteRepository;


    /**
     * Decrypt constructor.
     * @param \Magento\Framework\App\State $state
     * @param \Adfab\Gdpr\Helper\Cipher $cipher 
     * @param \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory
     * @param \Magento\Sales\Model\ResourceModel\Order\Address\CollectionFactory $orderAddressCollectionFactory
     * @param \Magento\Customer\Model\ResourceModel\Customer\CollectionFactory $customerCollectionFactory
     * @param \Magento\Quote\Model\ResourceModel\Quote\CollectionFactory $quoteCollectionFactory
     * @param \Magento\Customer\Model\ResourceModel\Address\CollectionFactory $customerAddressCollectionFactory
     * @param \Magento\Sales\Api\OrderRepositoryInterface $orderRepository
     * @param \Magento\Sales\Api\OrderAddressRepositoryInterface $orderAddressRepository
     * @param \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository
     * @param \Magento\Quote\Api\CartRepositoryInterface $quoteRepository
     * @param \Magento\Customer\Api\AddressRepositoryInterface $customerAddressRepository
     * @param string|null $name
     */
    public function __construct(
        \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory,
        \Magento\Sales\Model\ResourceModel\Order\Address\CollectionFactory $orderAddressCollectionFactory,
        \Magento\Sales\Model\ResourceModel\Order\Grid\CollectionFactory $orderGridCollectionFactory,
        \Magento\Customer\Model\ResourceModel\Customer\CollectionFactory $customerCollectionFactory,
        \Magento\Customer\Model\ResourceModel\Address\CollectionFactory $customerAddressCollectionFactory,
        \Magento\Quote\Model\ResourceModel\Quote\CollectionFactory $quoteCollectionFactory,
        \Magento\Newsletter\Model\ResourceModel\Subscriber\CollectionFactory $subscriberCollectionFactory,
//      These dependencies break default version installation
//        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
//        \Magento\Sales\Api\OrderAddressRepositoryInterface $orderAddressRepository,
//        \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository,
//        \Magento\Customer\Api\AddressRepositoryInterface $customerAddressRepository,
//        \Magento\Quote\Api\CartRepositoryInterface $quoteRepository,
        \Magento\Framework\App\State $state,
        \Adfab\Gdpr\Helper\Cipher $cipher,
        string $name = null
    ) {
        $this->orderCollectionFactory = $orderCollectionFactory;
        $this->orderAddressCollectionFactory = $orderAddressCollectionFactory;
        $this->orderGridCollectionFactory = $orderGridCollectionFactory;
        $this->customerCollectionFactory = $customerCollectionFactory;
        $this->customerAddressCollectionFactory = $customerAddressCollectionFactory;
        $this->quoteCollectionFactory = $quoteCollectionFactory;
        $this->subscriberCollectionFactory = $subscriberCollectionFactory;
//        $this->orderRepository = $orderRepository;
//        $this->orderAddressRepository = $orderAddressRepository;
//        $this->customerRepository = $customerRepository;
//        $this->customerAddressRepository = $customerAddressRepository;
//        $this->quoteRepository = $quoteRepository;
        $this->state = $state;
        $this->cipher = $cipher;

        parent::__construct($name);
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(
        \Symfony\Component\Console\Input\InputInterface $input,
        \Symfony\Component\Console\Output\OutputInterface $output
    ) {
        echo PHP_EOL; // Fix Area code error
        try {
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND);
        }

        $components = explode(',' , $input->getArgument('component'));
        if(empty($components)) {
            $output->writeln('Empty selected components');
            return false;
        }

        if($this->cipher->isActive()) {
            $output->writeln('It is necessary to deactivate encryption first from admin otherwise, when the data is saved, the data will be re-encrypted');
            return false;
        }

        if(in_array('order', $components)) {
            $output->writeln('Decrypting order data...');
            foreach ($this->orderCollectionFactory->create() as $o) {
                $order = $this->orderRepository->get($o->getId());

                try {
                    $this->orderRepository->save($order);
                } catch (\Exception $e) {
                    echo PHP_EOL . "OrderId {$o->getId()} exception: " . $e->getMessage();
                }
            }
        }

        if(in_array('order_address', $components)) {
            $output->writeln('Decrypting order address data...');
            foreach ($this->orderAddressCollectionFactory->create() as $oa) {
                $orderAddress = $this->orderAddressRepository->get($oa->getId());

                try {
                    $this->orderAddressRepository->save($orderAddress);
                } catch (\Exception $e) {
                    echo PHP_EOL . "OrderAddressId {$oa->getId()} exception: " . $e->getMessage();
                }
            }
        }

        if(in_array('order_grid', $components)) {
            $output->writeln('Decrypting order grid data...');
            foreach ($this->orderGridCollectionFactory->create() as $og) {
                die('TODO. Missing save function');

//                try {
//                    $this->orderGrid->save($orderAddress);
//                } catch (\Exception $e) {
//                    echo PHP_EOL . "OrderGridId {$oa->getId()} exception: " . $e->getMessage();
//                }
            }
        }

        if(in_array('customer', $components)) {
            $output->writeln('Decrypting customer data...');
            foreach ($this->customerCollectionFactory->create() as $c) {
                $customer = $this->customerRepository->getById($c->getId());

                try {
                    $this->customerRepository->save($customer);
                } catch (\Exception $e) {
                    echo PHP_EOL . "CustomerId {$c->getId()} exception: " . $e->getMessage();
                }
            }
        }

        if(in_array('customer_address', $components)) {
            $output->writeln('Decrypting customer address data...');
            foreach ($this->customerAddressCollectionFactory->create() as $ca) {
                $customerAddress = $this->customerAddressRepository->getById($ca->getId());
//                if(empty($customerAddress->getVatId())) {
//                    $customerAddress->setVatId('Missing');
//                }

                try {
                    $this->customerAddressRepository->save($customerAddress);
                } catch (\Exception $e) {
                    echo PHP_EOL . "CustomerAddressId {$ca->getId()} exception: " . $e->getMessage();
                }
            }
        }

        if(in_array('quote', $components)) {
            $output->writeln('Removing all quote data...');
            foreach ($this->quoteCollectionFactory->create() as $q) {
                try {
                    $quote = $this->quoteRepository->get($q->getId());
                    $this->quoteRepository->delete($quote);
                } catch (\Exception $e) {
                    echo PHP_EOL . "QuoteId {$q->getId()} exception: " . $e->getMessage();
                }
            }
        }

        if(in_array('subscriber', $components)) {
            $output->writeln('Decrypting subscriber data...');
            die('TO TEST');
            foreach ($this->subscriberCollectionFactory->create() as $subscriber) {
                try {
                    $subscriber->save();
                } catch (\Exception $e) {
                    echo PHP_EOL . "SubscriberId {$subscriber->getId()} exception: " . $e->getMessage();
                }
            }
        }

        $output->writeln('Decrypting finished.');
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this->setName("gdpr:decrypt");
        $this->setDescription("Decrypt all personnal data. Comma separated Components: order,order_address,order_grid,quote,customer,customer_address,subscriber");
        $this->setDefinition([
            new InputArgument('component', InputArgument::REQUIRED)
        ]);
        parent::configure();
    }
}
