<?php
namespace Adfab\Gdpr\Block;

use Adfab\Gdpr\Helper\Data;
use Magento\Customer\Api\AccountManagementInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Block\Account\Dashboard;
use Magento\Framework\View\Element\Template\Context;

/**
 * Customer front privacy settings block
 *
 * @property  profiling
 * @SuppressWarnings(PHPMD.DepthOfInheritance)
 */
class Settings extends \Magento\Customer\Block\Account\Dashboard
{
    /**
     * @var string
     */
    protected $_template = 'gdpr/account/settings.phtml';

    /**
     *
     * @var Data
     */
    protected $helper;

    private $profiling;

    /**
     * Constructor
     *
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Newsletter\Model\SubscriberFactory $subscriberFactory
     * @param CustomerRepositoryInterface $customerRepository
     * @param AccountManagementInterface $customerAccountManagement
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Newsletter\Model\SubscriberFactory $subscriberFactory,
        CustomerRepositoryInterface $customerRepository,
        AccountManagementInterface $customerAccountManagement,
        array $data = [],
        Data $helper
    ) {
        $this->helper = $helper;
        parent::__construct($context, $customerSession, $subscriberFactory, $customerRepository, $customerAccountManagement, $data);
    }

    /**
     *
     * {@inheritDoc}
     * @see \Magento\Framework\View\Element\AbstractBlock::_prepareLayout()
     */
    protected function _prepareLayout() {
        $customerId = $this->customerSession->getCustomerId();
        $customer = $this->customerRepository->getById($customerId);
        /* @var $customer \Magento\Customer\Model\Data\Customer */
        $profiling = $customer->getCustomAttribute('is_profiling_accepted') ? $customer->getCustomAttribute('is_profiling_accepted')->getValue(): 0;
        $this->setProfiling($profiling);
        return parent::_prepareLayout();
    }

    /**
     *
     * @return boolean
     */
    public function getProfiling()
    {
        return $this->profiling;
    }

    /**
     *
     * @param boolean $profiling
     * @return \Adfab\Gdpr\Block\Form\Optin
     */
    public function setProfiling($profiling)
    {
        $this->profiling = $profiling;
        return $this;
    }

    /**
     * @return bool
     * @SuppressWarnings(PHPMD.BooleanGetMethodName)
     */
    public function getIsProfiling()
    {
        return false;
    }

    /**
     * @return bool
     * @SuppressWarnings(PHPMD.BooleanGetMethodName)
     */
    public function getIsPrivacySettings()
    {
        return false;
    }

    /**
     * Return the save action Url.
     *
     * @return string
     */
    public function getAction()
    {
        return $this->getUrl('privacy/settings/save');
    }

    /**
     *
     * @return boolean
     */
    public function displayPrivacyPolicyAcceptance() {
        return $this->helper->getIsPrivacyPolicyAcceptedActive();
    }

    /**
     *
     * @return boolean
     */
    public function displayProfiling() {
        return $this->helper->getProfilingActive();
    }

    /**
     *
     * @return boolean
     */
    public function displayAccountDeletion() {
        return $this->helper->getAccountDeletionActive();
    }

    /**
     *
     * @return boolean
     */
    public function displayExport() {
        return $this->helper->getExportActive();
    }
}
