<?php
namespace Adfab\Gdpr\Model;

use Magento\Framework\App\Request\Http;
use Magento\Newsletter\Model\Subscriber;
use Magento\Framework\Model\ResourceModel\AbstractResource;

class NewsletterPlugin extends ModelPlugin
{

    protected $request;
    /**
     * @var \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress
     */
    private $remoteAddress;
    /**
     * @var \Magento\Customer\Model\CustomerFactory
     */
    private $customerFactory;
    /**
     * @var \Magento\Framework\App\State
     */
    private $state;

    /**
     * NewsletterPlugin constructor.
     * @param Http $request
     * @param \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $remoteAddress
     * @param \Magento\Customer\Model\CustomerFactory $customerFactory
     * @param \Adfab\Gdpr\Helper\Cipher $cipher
     */
    public function __construct(
        Http $request,
        \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $remoteAddress,
        \Magento\Customer\Model\CustomerFactory $customerFactory,
        \Adfab\Gdpr\Helper\Cipher $cipher,
        \Magento\Framework\App\State $state
    ) {
        $this->request = $request;
        $this->remoteAddress = $remoteAddress;
        $this->cipher = $cipher;
        $this->customerFactory = $customerFactory;
        $this->state = $state;
    }

//    public function beforeLoadByEmail(Subscriber $subscriber, $subscriberEmail)
//    {
//        if (in_array('subscriber_email', $this->subscriberFields)) {
//            return [
//                $this->cipher->cipher( $this->format('subscriber_email', $subscriberEmail) )
//            ];
//        }
//        return [
//            $subscriberEmail
//        ];
//    }

    public function beforeSave(Subscriber $subscriber) {
        if($this->state->getAreaCode() != \Magento\Framework\App\Area::AREA_FRONTEND) {
            return $subscriber;
        }

        if(empty($subscriber->getIpAddress()) || (filter_var($subscriber->getIpAddress(), FILTER_VALIDATE_IP) === false)) {
            $ipAddress = $this->remoteAddress->getRemoteAddress();
            if(!empty($ipAddress)) {
                $subscriber->setIpAddress($ipAddress);
            } else {
                $subscriber->setIpAddress('Cannot get IP address');
            }
        }

        $privacy = $this->request->getPost('is_privacy_policy_accepted', true);
        $subscriber->setIsPrivacyPolicyAccepted($privacy);

        $profiling = $this->request->getParam('is_profiling_accepted', 0) ? 1 : 0;
        $subscriber->setIsProfilingAccepted($profiling);

        $customerId = $subscriber->getCustomerId();
        if(!$customerId) {
            return $subscriber;
        }

        $customer = $this->customerFactory->create()
                        ->load($customerId);
        if(!$customer->getId()) {
            return $subscriber;
        }

        if(!$subscriber->getIsProfilingAccepted() && $customer->getIsProfilingAccepted()) {
            $subscriber->setIsProfilingAccepted($customer->getIsProfilingAccepted());
        }
        if(!$subscriber->getIsPrivacyPolicyAccepted() && $customer->getIsPrivacyPolicyAccepted()) {
            $subscriber->setIsPrivacyPolicyAccepted($customer->getIsPrivacyPolicyAccepted());
        }

        return $subscriber;
    }

//    public function beforeLoadByCustomerId(Subscriber $subscriber, $customerId)
//    {
//        $this->decipher($subscriber);
//        return $subscriber;
//    }
}
