<?php
namespace Adfab\Gdpr\Model;

use Magento\Customer\Model\Customer;
use Magento\Framework\App\Request\Http;

class CustomerPlugin extends ModelPlugin
{
    /**
     * @var \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress
     */
    private $remoteAddress;
    /**
     * @var Http
     */
    private $request;
    /**
     * @var \Magento\Framework\App\State
     */
    private $state;

    /**
     * CustomerPlugin constructor.
     * @param Http $request
     * @param \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $remoteAddress
     * @param \Adfab\Gdpr\Helper\Cipher $cipher
     */
    public function __construct(
        Http $request,
        \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $remoteAddress,
        \Adfab\Gdpr\Helper\Cipher $cipher,
        \Magento\Framework\App\State $state
    ) {
        $this->remoteAddress = $remoteAddress;
        $this->cipher = $cipher;
        $this->request = $request;
        $this->state = $state;
    }

    /**
     *
     * @param Customer $customer
     * @param string $email
     * @return string[]
     */
    public function beforeLoadByEmail(Customer $customer, $email)
    {
        if (in_array('email', $this->fields)) {
            return [
                $this->cipher->cipher( $this->format('email', $email) )
            ];
        }
        return [
            $email
        ];
    }

    public function beforeSave(Customer $customer)
    {
        if($this->state->getAreaCode() != \Magento\Framework\App\Area::AREA_FRONTEND) {
            return $customer;
        }

        if((!$customer->getId() && empty($customer->getIpAddress())) || (filter_var($customer->getIpAddress(), FILTER_VALIDATE_IP) === false))  {
            $ipAddress = $this->remoteAddress->getRemoteAddress();
            if(!empty($ipAddress)) {
                $customer->setIpAddress($ipAddress);
            } else {
                $customer->setIpAddress('Cannot get IP address');
            }
        }
        return $customer;
    }

}
