/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
	'jquery',
	'mage/validation'
], function ($) {
	'use strict';

	var agreementsInputPath = '.payment-method._active div.checkout-privacy-agreements input';

	return {
		/**
		 * Validate checkout agreements
		 *
		 * @returns {Boolean}
		 */
		validate: function () {

			var isValid = true;

			$(agreementsInputPath).each(function (index, element) {
				if (!$.validator.validateSingleElement(element, {
					errorElement: 'div'
				})) {
					isValid = false;
				}
			});

			return isValid;
		}
	};
});
