<?php

namespace Adfab\Gdpr\Model\Customer;

use Magento\Customer\Model\FileProcessorFactory;
use Magento\Customer\Model\ResourceModel\Customer\CollectionFactory as CustomerCollectionFactory;
use Magento\Eav\Model\Config;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponent\DataProvider\FilterPool;
use Magento\Ui\DataProvider\EavValidationRules;

class DataProvider extends \Magento\Customer\Model\Customer\DataProvider
{

    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        EavValidationRules $eavValidationRules,
        CustomerCollectionFactory $customerCollectionFactory,
        Config $eavConfig,
        FilterPool $filterPool,
        FileProcessorFactory $fileProcessorFactory = null,
        array $meta = [],
        array $data = [],
        ContextInterface $context = null,
        $allowToShowHiddenAttributes = true
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $eavValidationRules, $customerCollectionFactory, $eavConfig, $filterPool, $fileProcessorFactory, $meta, $data, $context, $allowToShowHiddenAttributes);
        $this->meta['customer']['children']['is_privacy_policy_accepted']['arguments']['data']['config']['disabled'] = true;
    }

}
