<?php
namespace Adfab\Gdpr\Controller\Settings;
use Magento\Customer\Api\CustomerRepositoryInterface as CustomerRepository;
class Save extends \Adfab\Gdpr\Controller\Privacy
{
    /**
     * @var \Magento\Framework\Data\Form\FormKey\Validator
     */
    protected $formKeyValidator;
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var CustomerRepository
     */
    protected $customerRepository;
    /**
     * @var \Magento\Newsletter\Model\Subscriber
     */
    private $subscriber;

    /**
     * Initialize dependencies.
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Framework\Data\Form\FormKey\Validator $formKeyValidator
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Newsletter\Model\Subscriber $subscriber
     * @param CustomerRepository $customerRepository
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\Data\Form\FormKey\Validator $formKeyValidator,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Newsletter\Model\Subscriber $subscriber,
        CustomerRepository $customerRepository
    ) {
        $this->formKeyValidator = $formKeyValidator;
        $this->customerRepository = $customerRepository;
        $this->storeManager = $storeManager;
        $this->subscriber = $subscriber;
        parent::__construct($context, $customerSession);
    }
    /**
     * Save newsletter subscription preference action
     *
     * @return void|null
     */
    public function execute()
    {
        $request = $this->getRequest();
        if (!$this->formKeyValidator->validate($request)) {
            return $this->_redirect('privacy/settings/');
        }
        $customerId = $this->_customerSession->getCustomerId();
        if ($customerId === null) {
            $this->messageManager->addError(__('Something went wrong while saving your privacy settings.'));
        } else {
            try {
                $customer = $this->customerRepository->getById($customerId);
                $subscriber = $this->subscriber->loadByCustomerId($customerId);
                /* @var $customer \Magento\Customer\Model\Data\Customer */
                $storeId = $this->storeManager->getStore()->getId();
                $customer->setStoreId($storeId);

                $profiling = $request->getParam('is_profiling_accepted', 0 ) ? 1 : 0;
                $customer->setCustomAttribute('is_profiling_accepted', $profiling);
                $this->customerRepository->save($customer);
                $subscriber->setIsProfilingAccepted($profiling)->save();
                $this->messageManager->addSuccessMessage('Your privacy settings was updated.');
            } catch (\Exception $e) {
                $this->messageManager->addError(__('Something went wrong while saving your privacy settings.'));
            }
        }
        $this->_redirect('privacy/settings/');
    }
}
