<?php

namespace Adfab\Gdpr\Block\Form;

use Adfab\Gdpr\Helper\Data;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

class Optin extends \Magento\Framework\View\Element\Template
{
    /**
     *
     * @var bool
     */
    protected $privacyPolicy = false;

    /**
     *
     * @var bool
     */
    protected $profiling = false;

    /**
     *
     * @var Data
     */
    protected $helper;

	/**
	 * @var \Magento\Framework\Locale\Resolver
	 */
	private $locale;

    /**
     *
     * @param Context $context
     * @param array $data
     * @param
     */
    public function __construct(
        Context $context,
		\Magento\Framework\Locale\Resolver $locale,
        array $data = [],
        Data $helper
    ) {
        $this->helper = $helper;
		$this->locale = $locale;
        parent::__construct($context, $data);
    }

    /**
     *
     * @return boolean
     */
    public function displayProfiling() {
        return $this->helper->getProfilingActive();
    }

    /**
     *
     * @return boolean
     */
    public function getPrivacyPolicyUrl() {
        return $this->helper->getPrivacyPolicyUrl('store');
    }

    /**
     *
     * @return boolean
     */
    public function getPrivacyPolicy()
    {
        return $this->privacyPolicy;
    }

    /**
     *
     * @param boolean $privacyPolicy
     * @return \Adfab\Gdpr\Block\Form\Optin
     */
    public function setIsPrivacyPolicyAccepted($privacyPolicy)
    {
        $this->privacyPolicy = $privacyPolicy;
        return $this;
    }

    /**
     *
     * @return boolean
     */
    public function getProfiling()
    {
        return $this->profiling;
    }

    /**
     *
     * @param boolean $profiling
     * @return \Adfab\Gdpr\Block\Form\Optin
     */
    public function setProfiling($profiling)
    {
        $this->profiling = $profiling;
        return $this;
    }



	public function getLocale(){
		$currentCode = $this->locale->getLocale();
		$langCode = strstr($currentCode, '_', true);

		return $langCode;
	}

}
